<?php include "head.php"; ?>

<style>
/* ===== MODERN RESPONSIVE STYLES ===== */
.projects-page {
    padding: 60px 20px;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    max-width: 1400px;
    margin: 0 auto;
}

/* HERO SECTION */
.hero-testimonial {
    max-width: 720px;
    margin: 0 auto 80px;
    text-align: center;
}

.hero-testimonial h1 {
    font-size: 2.5rem;
    margin-bottom: 16px;
    color: #1a1a1a;
    font-weight: 700;
    line-height: 1.2;
}

.hero-testimonial p {
    color: #666;
    font-size: 1.1rem;
    margin-bottom: 32px;
    line-height: 1.6;
}

.hero-testimonial video {
    width: 100%;
    max-width: 640px;
    border-radius: 16px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.15);
    transition: transform 0.3s;
}

.hero-testimonial video:hover {
    transform: translateY(-4px);
    box-shadow: 0 24px 70px rgba(0,0,0,0.2);
}

/* PROJECT SECTIONS */
.project-category {
    margin-bottom: 100px;
}

.category-header {
    text-align: center;
    margin-bottom: 40px;
}

.category-header h2 {
    font-size: 2rem;
    margin-bottom: 12px;
    color: #1a1a1a;
    font-weight: 700;
}

.category-header p {
    color: #666;
    max-width: 720px;
    margin: 0 auto;
    font-size: 1.05rem;
    line-height: 1.6;
}

/* CAROUSEL */
.carousel-container {
    position: relative;
    overflow: hidden;
    padding: 20px 0;
}

.carousel {
    display: flex;
    gap: 24px;
    overflow-x: auto;
    scroll-behavior: smooth;
    padding: 10px 20px 30px;
    -webkit-overflow-scrolling: touch;
    scrollbar-width: thin;
    scrollbar-color: #0d6efd #f0f0f0;
}

.carousel::-webkit-scrollbar {
    height: 8px;
}

.carousel::-webkit-scrollbar-track {
    background: #f0f0f0;
    border-radius: 10px;
}

.carousel::-webkit-scrollbar-thumb {
    background: #0d6efd;
    border-radius: 10px;
}

.carousel::-webkit-scrollbar-thumb:hover {
    background: #0b5ed7;
}

/* CAROUSEL ITEMS */
.carousel-item {
    min-width: 300px;
    max-width: 380px;
    flex-shrink: 0;
    background: #fff;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    cursor: pointer;
}

.carousel-item:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 40px rgba(0,0,0,0.15);
}

.carousel-item img,
.carousel-item video {
    width: 100%;
    height: 280px;
    object-fit: cover;
    display: block;
    background: #f5f5f5;
}

/* CONTROLS */
.controls {
    display: flex;
    justify-content: center;
    gap: 16px;
    margin-top: 24px;
}

.controls button {
    padding: 12px 24px;
    border: 2px solid #0d6efd;
    background: white;
    color: #0d6efd;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 600;
    font-size: 15px;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 8px;
}

.controls button:hover {
    background: #0d6efd;
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(13, 110, 253, 0.3);
}

.controls button:active {
    transform: translateY(0);
}

/* LIGHTBOX */
.lightbox {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.95);
    z-index: 9999;
    justify-content: center;
    align-items: center;
    padding: 20px;
}

.lightbox.active {
    display: flex;
}

.lightbox-content {
    max-width: 90%;
    max-height: 90%;
    border-radius: 8px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.5);
}

.lightbox-close {
    position: absolute;
    top: 20px;
    right: 30px;
    font-size: 40px;
    color: white;
    cursor: pointer;
    z-index: 10000;
    background: rgba(255,255,255,0.1);
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}

.lightbox-close:hover {
    background: rgba(255,255,255,0.2);
    transform: rotate(90deg);
}

/* EMPTY STATE */
.empty-state {
    text-align: center;
    padding: 80px 20px;
    color: #999;
}

.empty-state h2 {
    font-size: 1.8rem;
    margin-bottom: 12px;
}

/* RESPONSIVE */
@media(max-width: 768px) {
    .projects-page {
        padding: 40px 16px;
    }
    
    .hero-testimonial h1 {
        font-size: 1.8rem;
    }
    
    .hero-testimonial p {
        font-size: 1rem;
    }
    
    .category-header h2 {
        font-size: 1.6rem;
    }
    
    .carousel-item {
        min-width: 260px;
        max-width: 320px;
    }
    
    .carousel-item img,
    .carousel-item video {
        height: 220px;
    }
    
    .controls button {
        padding: 10px 18px;
        font-size: 14px;
    }
    
    .lightbox-close {
        top: 10px;
        right: 10px;
        font-size: 32px;
        width: 44px;
        height: 44px;
    }
}

@media(max-width: 480px) {
    .carousel-item {
        min-width: 240px;
    }
    
    .carousel {
        gap: 16px;
        padding: 10px 10px 24px;
    }
}

/* LOADING ANIMATION */
@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

.loading {
    animation: pulse 1.5s ease-in-out infinite;
}
</style>

<div class="projects-page">

    <!-- HERO TESTIMONIAL VIDEO -->
    <section class="hero-testimonial">
        <h1>Trusted Electrical & Solar Experts</h1>
        <p>
            Hear directly from one of our satisfied clients about their experience
            working with FEMTECH WAVES LIMITED.
        </p>
        <video controls preload="metadata" poster="uploads/projects/video-poster.jpg">
            <source src="uploads/projects/femtechwaves-solar-and-electical-company-Abuja.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
    </section>

    <!-- DYNAMIC PROJECT CATEGORIES -->
    <?php
    $categories = glob("uploads/projects/*", GLOB_ONLYDIR);
    
    if (empty($categories)):
    ?>
        <div class="empty-state">
            <h2>🚧 Coming Soon</h2>
            <p>Our project portfolio is being updated. Check back soon!</p>
        </div>
    <?php
    else:
        foreach($categories as $index => $category):
            $slug = basename($category);
            
            // Get description if it exists
            $descFile = "$category/.description.txt";
            $description = file_exists($descFile) 
                ? file_get_contents($descFile) 
                : "Completed projects showcasing quality workmanship and excellence.";
            
            // Get all media files
            $files = glob("$category/*.{jpg,jpeg,png,webp,mp4}", GLOB_BRACE);
            
            if (empty($files)) continue; // Skip empty categories
    ?>
        <section class="project-category">
            <div class="category-header">
                <h2><?= ucwords(str_replace('-', ' ', $slug)); ?></h2>
                <p><?= htmlspecialchars($description); ?></p>
            </div>

            <div class="carousel-container">
                <div class="carousel" id="carousel<?= $index ?>">
                    <?php foreach($files as $fileIndex => $file): 
                        $isVideo = preg_match('/\.(mp4|webm)$/i', $file);
                        $fileName = basename($file);
                    ?>
                        <div class="carousel-item" onclick="openLightbox('<?= htmlspecialchars($file, ENT_QUOTES) ?>', <?= $isVideo ? 'true' : 'false' ?>)">
                            <?php if($isVideo): ?>
                                <video preload="metadata" loading="lazy">
                                    <source src="<?= htmlspecialchars($file) ?>" type="video/mp4">
                                </video>
                            <?php else: ?>
                                <img 
                                    src="<?= htmlspecialchars($file) ?>" 
                                    loading="lazy"
                                    alt="<?= ucwords(str_replace('-', ' ', $slug)); ?> - Project Image <?= $fileIndex + 1 ?>"
                                    title="Click to view full size"
                                >
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="controls">
                <button onclick="scrollCarousel('carousel<?= $index ?>', -1)" aria-label="Previous">
                    <span>‹</span> Previous
                </button>
                <button onclick="scrollCarousel('carousel<?= $index ?>', 1)" aria-label="Next">
                    Next <span>›</span>
                </button>
            </div>
        </section>
    <?php 
        endforeach;
    endif;
    ?>

</div>

<!-- LIGHTBOX -->
<div class="lightbox" id="lightbox" onclick="closeLightbox()">
    <span class="lightbox-close" onclick="closeLightbox()">&times;</span>
    <img id="lightboxImg" class="lightbox-content" src="" alt="Full size image" style="display:none;">
    <video id="lightboxVideo" class="lightbox-content" controls style="display:none;">
        <source src="" type="video/mp4">
    </video>
</div>

<script>
// Smooth carousel scrolling
function scrollCarousel(id, direction) {
    const carousel = document.getElementById(id);
    const scrollAmount = 340; // Slightly more than item width for smooth transition
    carousel.scrollBy({
        left: direction * scrollAmount,
        behavior: 'smooth'
    });
}

// Lightbox functionality
function openLightbox(src, isVideo) {
    const lightbox = document.getElementById('lightbox');
    const img = document.getElementById('lightboxImg');
    const video = document.getElementById('lightboxVideo');
    
    if (isVideo) {
        video.querySelector('source').src = src;
        video.load();
        video.style.display = 'block';
        img.style.display = 'none';
    } else {
        img.src = src;
        img.style.display = 'block';
        video.style.display = 'none';
    }
    
    lightbox.classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    const lightbox = document.getElementById('lightbox');
    const video = document.getElementById('lightboxVideo');
    
    lightbox.classList.remove('active');
    video.pause();
    document.body.style.overflow = 'auto';
}

// Close lightbox on ESC key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLightbox();
    }
});

// Lazy loading optimization
if ('IntersectionObserver' in window) {
    const imageObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const img = entry.target;
                if (img.dataset.src) {
                    img.src = img.dataset.src;
                    img.removeAttribute('data-src');
                }
                observer.unobserve(img);
            }
        });
    });
    
    document.querySelectorAll('img[data-src]').forEach(img => imageObserver.observe(img));
}
</script>

<?php include "footer.php"; ?>
