<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$category = $_GET['category'] ?? '';
if (empty($category)) {
    header('Location: admin.php?error=Invalid category');
    exit;
}

$categoryPath = "uploads/projects/" . $category;

if (!is_dir($categoryPath)) {
    header('Location: admin.php?error=Category not found');
    exit;
}

// Recursive delete function
function deleteDirectory($dir) {
    if (!file_exists($dir)) return true;
    if (!is_dir($dir)) return unlink($dir);
    
    foreach (scandir($dir) as $item) {
        if ($item == '.' || $item == '..') continue;
        if (!deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) return false;
    }
    
    return rmdir($dir);
}

if (deleteDirectory($categoryPath)) {
    header('Location: admin.php?success=' . urlencode("Category deleted successfully"));
} else {
    header('Location: admin.php?error=' . urlencode("Failed to delete category"));
}
exit;
?>
