<?php
session_start();

// Simple authentication check
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

include "head.php";

// Get all categories
$categories = glob("uploads/projects/*", GLOB_ONLYDIR);
?>

<style>
.admin-container {
    max-width: 1200px;
    margin: 80px auto;
    padding: 20px;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
}
.admin-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 40px;
    padding-bottom: 20px;
    border-bottom: 2px solid #e0e0e0;
}
.admin-header h1 {
    font-size: 2rem;
    color: #333;
}
.btn {
    padding: 12px 24px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    display: inline-block;
    transition: all 0.3s;
}
.btn-primary {
    background: #0d6efd;
    color: white;
}
.btn-primary:hover {
    background: #0b5ed7;
}
.btn-danger {
    background: #dc3545;
    color: white;
}
.btn-danger:hover {
    background: #bb2d3b;
}
.btn-secondary {
    background: #6c757d;
    color: white;
}
.btn-logout {
    background: #fff;
    color: #dc3545;
    border: 2px solid #dc3545;
}
.categories-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 24px;
    margin-top: 30px;
}
.category-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transition: transform 0.3s, box-shadow 0.3s;
}
.category-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
}
.category-card h3 {
    margin: 0 0 12px 0;
    color: #333;
    font-size: 1.4rem;
}
.category-card .meta {
    color: #666;
    font-size: 14px;
    margin-bottom: 20px;
}
.category-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}
.category-actions .btn {
    flex: 1;
    text-align: center;
    padding: 10px 16px;
    font-size: 13px;
}
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: #999;
}
.empty-state img {
    width: 120px;
    opacity: 0.3;
    margin-bottom: 20px;
}
.alert {
    padding: 16px 20px;
    border-radius: 8px;
    margin-bottom: 24px;
}
.alert-success {
    background: #d1e7dd;
    color: #0f5132;
    border: 1px solid #badbcc;
}
.alert-error {
    background: #f8d7da;
    color: #842029;
    border: 1px solid #f5c2c7;
}
@media(max-width: 768px) {
    .admin-header {
        flex-direction: column;
        gap: 16px;
        align-items: flex-start;
    }
    .categories-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="admin-container">
    <div class="admin-header">
        <h1>📁 Project Categories Manager</h1>
        <div style="display: flex; gap: 12px;">
            <a href="add_category.php" class="btn btn-primary">+ Add New Category</a>
            <a href="admin_logout.php" class="btn btn-logout">Logout</a>
        </div>
    </div>

    <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success">
            <?= htmlspecialchars($_GET['success']) ?>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-error">
            <?= htmlspecialchars($_GET['error']) ?>
        </div>
    <?php endif; ?>

    <?php if (empty($categories)): ?>
        <div class="empty-state">
            <h2>No Categories Yet</h2>
            <p>Start by creating your first project category!</p>
            <a href="add_category.php" class="btn btn-primary" style="margin-top: 20px;">+ Create First Category</a>
        </div>
    <?php else: ?>
        <div class="categories-grid">
            <?php foreach($categories as $category):
                $slug = basename($category);
                $files = glob("$category/*.{jpg,jpeg,png,mp4,webp}", GLOB_BRACE);
                $fileCount = count($files);
            ?>
                <div class="category-card">
                    <h3><?= ucwords(str_replace('-', ' ', $slug)) ?></h3>
                    <div class="meta">
                        📸 <?= $fileCount ?> media file<?= $fileCount !== 1 ? 's' : '' ?>
                    </div>
                    <div class="category-actions">
                        <a href="manage_media.php?category=<?= urlencode($slug) ?>" class="btn btn-primary">
                            Manage Media
                        </a>
                        <a href="delete_category.php?category=<?= urlencode($slug) ?>" 
                           class="btn btn-danger"
                           onclick="return confirm('Delete this category and all its media? This cannot be undone!')">
                            Delete
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php include "footer.php"; ?>
