<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

/**
 * Slug generator
 */
function slugify($text) {
    $text = strtolower(trim($text));
    $text = preg_replace('/[^a-z0-9\s-]/', '', $text);
    $text = preg_replace('/[\s-]+/', '-', $text);
    return trim($text, '-');
}

$error = "";

/**
 * Base upload directory (SHARED HOSTING SAFE)
 */
$baseDir = $_SERVER['DOCUMENT_ROOT'] . "/uploads/projects";

/**
 * Ensure base directory exists
 */
if (!is_dir($baseDir)) {
    mkdir($baseDir, 0775, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name        = trim($_POST['category_name'] ?? '');
    $description = trim($_POST['category_description'] ?? '');

    if ($name === '') {
        $error = "Category name is required.";
    } else {

        $slug = slugify($name);
        $categoryPath = $baseDir . "/" . $slug;

        if (is_dir($categoryPath)) {
            $error = "Category already exists.";
        } else {

            if (mkdir($categoryPath, 0775, true)) {

                // Save description
                if ($description !== '') {
                    file_put_contents(
                        $categoryPath . "/description.txt",
                        htmlspecialchars($description),
                        LOCK_EX
                    );
                }

                // Redirect to dashboard
                header("Location: admin.php?success=category_created");
                exit;
            } else {
                $error = "Failed to create category. Check folder permissions.";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Category</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body {
    font-family: system-ui, -apple-system, sans-serif;
    background: #f3f4f6;
    padding: 20px;
}
.card {
    max-width: 520px;
    margin: auto;
    background: #ffffff;
    padding: 28px;
    border-radius: 16px;
    box-shadow: 0 25px 50px rgba(0,0,0,0.08);
}
h2 {
    margin-bottom: 20px;
    font-size: 22px;
}
input, textarea {
    width: 100%;
    padding: 14px;
    margin-bottom: 16px;
    border-radius: 10px;
    border: 1px solid #d1d5db;
    font-size: 15px;
}
textarea { resize: vertical; }
button {
    width: 100%;
    padding: 14px;
    background: #2563eb;
    color: #fff;
    border: none;
    border-radius: 10px;
    font-size: 16px;
    cursor: pointer;
}
button:hover {
    background: #1d4ed8;
}
.error {
    background: #fee2e2;
    color: #991b1b;
    padding: 12px;
    border-radius: 8px;
    margin-bottom: 15px;
}
</style>
</head>

<body>

<div class="card">
    <h2>Create New Category</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="text" name="category_name" placeholder="Category Name" required>
        <textarea name="category_description" placeholder="Optional category description"></textarea>
        <button type="submit">Create Category</button>
    </form>
</div>

</body>
</html>
